

FUNCTION INTERSEQCOLORING(
       N,M,HI:INTEGER;
   VAR GR    :GRAPH;
   VAR SEQ   :ARRN):INTEGER;

   TYPE PQUEUE=^QUEUE;
        QUEUE = RECORD
                   VERTEX:INTEGER;
                   NEXT  :PQUEUE
                END;
   VAR H,H1,H2,I,I1,I2,J,J1,K,KK,K1,L,LL:INTEGER;
       EX                               :BOOLEAN;
       SGN                              :ARRN;
       HQ,PQ,PQ1,PQ2,PQ3                :PQUEUE;
       P,P1,P2,P3                       :VERTPOINT;

   PROCEDURE MATES;
      { THIS PROCEDURE MATCHES INTO PAIRS ELEMENTS OF ADJACENCY LISTS
        (VERTLIST ) WHICH CORRESPOND TO THE SAME EDGE OF THE GRAPH }
      VAR I,J :INTEGER;
          DEGG:ARRN;
          ARR1:ARRM;
          ARR2:ARRMPOINT;
          ARR3:ARRNPOINT;
   BEGIN
      SGN[1]:=1;  I1:=GR[1].DEGREE;
      DEGG[1]:=I1;
      FOR I:=2 TO N DO BEGIN
         SGN[I]:=I1+1;  I1:=I1+GR[I].DEGREE;
         DEGG[I]:=I1
      END;  { FOR I }
      I1:=1;
      FOR I:=1 TO N DO BEGIN
         I2:=DEGG[I];
         P:=GR[I].ADJLIST;
         FOR J:=I1 TO I2 DO BEGIN
            L:=P^.VERTEX;
            K:=SGN[L];  SGN[L]:=K+1;
            ARR1[K]:=I;  ARR2[K]:=P;
            P:=P^.NEXT
         END;  { FOR J }
         I1:=I2+1
      END;  { FOR I }
      I1:=1;
      FOR I:=1 TO N DO BEGIN
         I2:=DEGG[I];
         FOR J:=I1 TO I2 DO ARR3[ARR1[J]]:=ARR2[J];
         P:=GR[I].ADJLIST;
         FOR J:=I1 TO I2 DO BEGIN
            P^.MATE:=ARR3[P^.VERTEX];  P:=P^.NEXT
         END;
         I1:=I2+1
      END  { FOR I }
   END;  { MATES }

   PROCEDURE INSERT(I:INTEGER);
      { THIS PROCEDURE INSERTS VERTEX P1^.VERTEX INTO
        LIST OF I-COLOR NEIGHBORS OF VERTEX J }
   BEGIN
      P2:=GR[J].COLPOINT[I];
      GR[J].COLPOINT[I]:=P1;
      P1^.COLMATE1:=P2;  P1^.COLMATE2:=NIL;
      IF P2 <> NIL THEN P2^.COLMATE2:=P1
   END;  { INSERT }

BEGIN                                                   { MAIN BODY }
   MATES;
   FOR I:=1 TO N DO BEGIN                          { INITIALIZATION }
      GR[I].COLOR:=0;
      FOR J:=1 TO HI DO GR[I].COLPOINT[J]:=NIL
   END;
   K:=1;  K1:=1;
   FOR I:=1 TO N DO BEGIN
      I1:=SEQ[I];                       { I1 - VERTEX TO BE COLORED }
      IF I > 1 THEN BEGIN
         I2:=GR[I1].DEGREE+1;
         IF I < I2 THEN I2:=I;
         FOR L:=1 TO I2 DO SGN[L]:=0;
         P:=GR[I1].ADJLIST;
         WHILE P <> NIL DO BEGIN
            L:=GR[P^.VERTEX].COLOR;
            IF L <> 0 THEN SGN[L]:=1;
            P:=P^.NEXT
         END;
         K1:=1;
         WHILE SGN[K1] <> 0 DO K1:=K1+1;
                           { K1 IS THE SMALLEST COLOR FOR VERTEX I1 }
         IF (K1 > 2) AND (K1 > K) AND ((I > 4) OR ((I=4)
             AND (K=2))) THEN BEGIN        { SEARCH FOR INTERCHANGE }
            EX:=TRUE;  KK:=0;
            WHILE EX AND (KK < K) DO BEGIN
               KK:=KK+1;  HQ:=NIL;
               P:=GR[I1].COLPOINT[KK];
               WHILE P <> NIL DO BEGIN
                  NEW(PQ1);
                  IF HQ = NIL THEN PQ2:=PQ1;
                  PQ1^.NEXT:=HQ;  HQ:=PQ1;
                  PQ1^.VERTEX:=P^.VERTEX;
                  P:=P^.COLMATE1
               END;  { WHILE P <> NIL }
               LL:=KK;
               WHILE EX AND (LL < K) DO BEGIN
                  PQ3:=PQ2;  PQ2^.NEXT:=NIL;
                  FOR J:=1 TO N DO SGN[J]:=0;
                  PQ:=HQ;
                  WHILE PQ <> NIL DO BEGIN
                     SGN[PQ^.VERTEX]:=1;  PQ:=PQ^.NEXT
                  END;
                  LL:=LL+1;  PQ:=HQ;
                  WHILE PQ <> NIL DO BEGIN
                                 { CONSTRUCTION OF (KK,LL)-SUBGRAPH }
                     H:=PQ^.VERTEX;  H1:=SGN[H];
                     IF GR[H].COLOR = KK THEN H2:=LL ELSE H2:=KK;
                     P:=GR[H].COLPOINT[H2];
                     WHILE P <> NIL DO BEGIN
                        { SEARCH FOR H2-COLOR NEIGHBORS OF VERTEX H }
                        I2:=P^.VERTEX;
                        IF SGN[I2] = 0 THEN BEGIN
                           SGN[I2]:=-H1;
                           NEW(PQ1);
                           PQ1^.NEXT:=NIL;  PQ3^.NEXT:=PQ1;
                           PQ3:=PQ1;  PQ1^.VERTEX:=I2
                        END;  { IF SGN[I2] = 0 }
                        P:=P^.COLMATE1
                     END;  { WHILE P <> NIL }
                     PQ:=PQ^.NEXT
                  END;  { WHILE PQ <> NIL }
                  EX:=FALSE;
                  P:=GR[I1].COLPOINT[LL];
                  WHILE (P <> NIL) AND (NOT EX) DO BEGIN
                     EX:=SGN[P^.VERTEX] <> 0;
                     P:=P^.COLMATE1
                  END
               END  { WHILE EX AND (LL < K) - SEARCH FOR COLOR LL }
            END;  { WHILE EX AND (KK < K) - SEARCH FOR COLOR KK }
               { IF EX=FALSE THEN FEASIBLE (KK,LL)-SUBGRAPH HAS
                  BEEN FOUND }
            IF NOT EX THEN BEGIN
               PQ:=HQ;
               WHILE PQ <> NIL DO BEGIN
                  I2:=PQ^.VERTEX;
                  IF GR[I2].COLOR = KK THEN GR[I2].COLOR:=LL
                  ELSE GR[I2].COLOR:=KK;
                  P:=GR[I2].COLPOINT[LL];
                  GR[I2].COLPOINT[LL]:=GR[I2].COLPOINT[KK];
                  GR[I2].COLPOINT[KK]:=P;
                  PQ:=PQ^.NEXT
               END;  { WHILE PQ <> NIL }
               PQ:=HQ;          { INTERCHANGE OF POINTERS TO COLORS }
               WHILE PQ <> NIL DO BEGIN
                  I2:=PQ^.VERTEX;
                  H:=GR[I2].COLOR;
                  IF H = LL THEN H1:=KK ELSE H1:=LL;
                  P:=GR[I2].ADJLIST;
                  WHILE P <> NIL DO BEGIN
                     J:=P^.VERTEX;
                     IF GR[J].COLOR <> H1 THEN BEGIN
                        P1:=P^.MATE;  P2:=P1^.COLMATE1;
                        P3:=P1^.COLMATE2;
                        IF P3 = NIL THEN GR[J].COLPOINT[H1]:=P2
                        ELSE P3^.COLMATE1:=P2;
                        IF P2 <> NIL THEN P2^.COLMATE2:=P3;
                        P1^.COLMATE2:=NIL;
                        INSERT(H)
                     END;  { IF GR[J].COLOR <> H1 }
                     P:=P^.NEXT
                  END;  { WHILE P <> NIL }
                  PQ:=PQ^.NEXT
               END;  { WHILE PQ <> NIL }
               K1:=KK
            END  { IF NOT EX }
         END  { IF (K1 > 2) ... }
      END;  { IF I > 1 }
      GR[I1].COLOR:=K1;               { VERTEX I1 MAY HAVE COLOR K1 }
      IF K1 > K THEN K:=K1;
      P:=GR[I1].ADJLIST;
      WHILE P <> NIL DO BEGIN
         J:=P^.VERTEX;  P1:=P^.MATE;
         INSERT(K1);
         P:=P^.NEXT
      END  { WHILE P <> NIL }
   END;  { FOR I }
   INTERSEQCOLORING:=K
END;  { INTERSEQCOLORING }
